﻿//Copyright (C) 2010  Jonathan Preece
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System.Collections.Generic;
using System.Drawing;

namespace RevisionAnalyser.Global.EasterEgg
{
    public interface ISnake
    {
        /// <summary>
        /// Returns all the segments of the Snake
        /// </summary>
        List<Segment> ToSegments { get; }

        /// <summary>
        /// Gets the Snakes body, excluding the head
        /// </summary>
        Rectangle[] GetSnakeBody { get; }

        /// <summary>
        /// Gets the Snakes body only, as segments
        /// </summary>
        List<Segment> GetSnakeBodyAsSegments { get; }

        /// <summary>
        /// Returns all segments as Rectangles so they can be drawn on the canvas
        /// </summary>
        Rectangle[] ToRectangles { get; }

        /// <summary>
        /// Gets or sets the direction in which the Snake is currently moving
        /// </summary>
        Direction MovingDirection { get; set; }

        /// <summary>
        /// Gets the width of each segment of the snake
        /// </summary>
        int Width { get; }

        /// <summary>
        /// Gets the height of each segment of the snake
        /// </summary>
        int Height { get; }

        /// <summary>
        /// Increases the size of the Snake by one segment
        /// </summary>
        void Add();

        /// <summary>
        /// Resets the Snake back to its starting size and position
        /// </summary>
        void Reset();

        /// <summary>
        /// Moves the Snake in the given <see cref="MovingDirection"/>.
        /// </summary>
        void Move();

        /// <summary>
        /// Gets the Snakes head segment
        /// </summary>
        Segment GetHeadSegment();
    }
}